/* FINAL DRAGON MAP MOVEMENT MODULE 4/25/05
JESSE HARRIS
ALLOW CHARACTER TO INTERACT WITH MAP AND NPCS
WORLD MAP DUNGEON LOCATIONS ARE HARD CODED HERE
THE BLUE DRAGON BATTLE PLOT CODE IS HERE AS WELL
COLLISION IS BASED ON METAMAP TILE COLLISION
*/
#include <mygba.h>
#include <hel.h>
#include "mtwister.h"

#include "gfx/sprite/celessprite.raw.c"
#include "stuff.hpp"

//very useful
#define DOWN 1
#define UP 2
#define RIGHT 3
#define LEFT 4

extern u16 delay;
extern u8 sprites[127];
extern TMapScrollInfo MapInfo[];
extern player watashi;
extern map maplist[];
extern short tempspritex[127];
extern short tempspritey[127];

u8 stepstobattle;

u8 dir = 0;

u16 tempy = -16;
u16 tempx = 240;
u16 charx = 42;
u16 chary = 9;

//return 0 to keep current state and return 1 to change to status screen state
//return 2 to change maps
int myMap()
{
    //these shorter easier to read variables make the code more readable and easier to create
short curx = watashi.x;  //curx = current x value of player
short cury = watashi.y;  //cury = current y value of player
short curmap = watashi.map;  //curmap is current map of player
short mapx = maplist[curmap].sizex;  //the size of the map in x
short mapy = maplist[curmap].sizey;  //the size of the map in y

    hel_PadReadState();
    //movement right collision detection
    if(hel_Pad.Held.Right && !delay)
    {
        u8 isopen = 1;
        for (int x = 0; x < maplist[watashi.map].numsprite; x++)
        {
            if(watashi.x + 1 == maplist[watashi.map].sprite[x * 4] && watashi.y == maplist[watashi.map].sprite[x * 4 + 1])
            {
                isopen = 0;
            }
        }
        if(maplist[curmap].coltable[ maplist[curmap].map[ (curx + 1) + (cury * mapx) ] ]  && isopen)
        {
            if(curx < mapx-1)
            {
                watashi.x++;
                delay = 16;
                dir = RIGHT;
            }
        }
        else
        {
            ham_SetObjHFlip(sprites[0], 1);
            ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[2 * 16 * 32 / 2]);
        }
        watashi.dir = RIGHT;
    }
    //movement down collision detection
    if(hel_Pad.Held.Down && !delay)
    {
        u8 isopen = 1;
        for (int x = 0; x < maplist[watashi.map].numsprite; x++)
        {
            if(watashi.x == maplist[watashi.map].sprite[x * 4] && watashi.y + 1 == maplist[watashi.map].sprite[x * 4 + 1])
            {
                isopen = 0;
            }
        }
        if(maplist[curmap].coltable[ maplist[ curmap].map[curx + ((cury + 1) * mapx)] ] && isopen)
        {
            if(cury < mapy-1)
            {
                watashi.y++;
                delay = 16;
                dir = DOWN;;
            }
        }
        else
        {
            ham_SetObjHFlip(sprites[0], 0);
            ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[3 * 16 * 32 /2]);
        }
        watashi.dir = DOWN;
    }
    //movement left collision detection
    if(hel_Pad.Held.Left && !delay)
    {
        u8 isopen = 1;
        for (int x = 0; x < maplist[watashi.map].numsprite; x++)
        {
            if(watashi.x - 1 == maplist[watashi.map].sprite[x * 4] && watashi.y == maplist[watashi.map].sprite[x * 4 + 1])
            {
                isopen = 0;
            }
        }
        if(maplist[curmap].coltable[ maplist[ curmap].map[(curx - 1) + (cury * mapx)] ] && isopen)
        {
            if(curx > 0)
            {
                watashi.x--;
                delay = 16;
                dir = LEFT;
            }
        }
        else
        {
            ham_SetObjHFlip(sprites[0], 0);
            ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[2 * 16 * 32 / 2]);
        }
        watashi.dir = LEFT;
    }
    //movement Up collision detection
    if(hel_Pad.Held.Up && !delay)
    {
        u8 isopen = 1;
        for (int x = 0; x < maplist[watashi.map].numsprite; x++)
        {
            if(watashi.x == maplist[watashi.map].sprite[x * 4] && watashi.y - 1 == maplist[watashi.map].sprite[x * 4 + 1])
            {
                isopen = 0;
            }
        }
        if(maplist[curmap].coltable[ maplist[ curmap].map[curx + ((cury - 1) * mapx)] ]  && isopen)
        {
            if(cury > 0)
            {
                watashi.y--;
                delay = 16;
                dir = UP;
            }
        }
        else
        {
            ham_SetObjHFlip(sprites[0], 0);
            ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[4 * 16 * 32 / 2]);
        }
        watashi.dir = UP;
    }
    
    //BEGIN WORLD MAP HARD CODE LOCATION CHECK
    if(dir && curmap == 3 && watashi.x == 36 && watashi.y == 25)
    {
        dir = 0;
        watashi.x = 19;
        watashi.y = 38;
        watashi.map = 1;
        return 2;
    }
    if(dir && curmap == 3 && watashi.x == 44 && watashi.y == 43)
    {
        dir = 0;
        watashi.x = 8;
        watashi.y = 14;
        watashi.map = 4;
        return 2;
    }
    if(dir && curmap == 3 && watashi.x == 93 && watashi.y == 5)
    {
        dir = 0;
        watashi.x = 2;
        watashi.y = 39;
        watashi.map = 5;
        return 2;
    }
    if(dir && curmap == 3 && watashi.x == 88 && watashi.y == 82)
    {
        dir = 0;
        watashi.x = 9;
        watashi.y = 19;
        watashi.map = 9;
        return 2;
    }
    if(dir && curmap == 3 && watashi.x == 20 && watashi.y == 32)
    {
        dir = 0;
        watashi.x = 9;
        watashi.y = 19;
        watashi.map = 8;
        return 2;
    }

    //END WORLSD MAP HARD CODE LOCATION CHECK
    
    
    
    

    //CHECK FOR PEOPLE TO TALK TO /  PRESS A TO TALK TO THEM
    if(hel_Pad.Held.A && !delay && !dir)
    {
        for (int x = 0; x < maplist[watashi.map].numsprite; x++)
        {
            if(watashi.dir == LEFT && (watashi.x - 1 == maplist[watashi.map].sprite[x * 4] && watashi.y == maplist[watashi.map].sprite[x * 4 + 1]))
            {
                watashi.textnum = maplist[watashi.map].sprite[x * 4 + 3];
                return 3;
            }
            if(watashi.dir == RIGHT && (watashi.x + 1 == maplist[watashi.map].sprite[x * 4] && watashi.y == maplist[watashi.map].sprite[x * 4 + 1]))
            {
                watashi.textnum = maplist[watashi.map].sprite[x * 4 + 3];
                return 3;
            }
            if(watashi.dir == DOWN && (watashi.x == maplist[watashi.map].sprite[x * 4] && watashi.y + 1 == maplist[watashi.map].sprite[x * 4 + 1]))
            {
                watashi.textnum = maplist[watashi.map].sprite[x * 4 + 3];
                return 3;
            }
            if(watashi.dir == UP && (watashi.x == maplist[watashi.map].sprite[x * 4] && watashi.y - 1 == maplist[watashi.map].sprite[x * 4 + 1]))
            {
                watashi.textnum = maplist[watashi.map].sprite[x * 4 + 3];
                return 3;
            }
        }
    }
    //END CHECK FOR PEOPLE TO TALK TO
    
    
    //CHECK FOR START BUTTON PRESS AND BRING UP STATUS SCREEN
    if(hel_Pad.Held.Start && !delay  && !dir)
    {
        return 1;
    }
    //END START BUTTON PRESS CHECK
    
    
    //Scrolling info  -  for when the character moves, the map must move around her
    //Also contained in here is the player sprite updating code for each direction
    if(delay % 2 && dir == UP)
    {
        //sprite updatin info
        if (delay == 15)
            {
                ham_SetObjHFlip(sprites[0], 0);
                ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[1 * 16 * 32 /2]);
            }
        if (delay == 7)
            {
                ham_SetObjHFlip(sprites[0], 0);
                ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[5 * 16 * 32 /2]);
            }
        //end sprite updating info
        //NPC Update code
        for (int x = 0; x < maplist[watashi.map].numsprite; x++)
        {
            if((watashi.y <= maplist[watashi.map].sprite[x * 4 + 1]  + 5)  && (watashi.y >= maplist[watashi.map].sprite[x * 4 + 1]  - 5)) //9
            {
                ham_SetObjY(x+1, (tempspritey[x+1] += 2));
            }
        }
        //END NPC Update code
        hel_MapScrollBy(&MapInfo[3], 0, -2);
    }

    if(delay % 2 && dir == LEFT)
    {
        //sprite updatin info
        if (delay == 15)
            {
                ham_SetObjHFlip(sprites[0], 0);
                ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[7 * 16 * 32 /2]);
            }
        if (delay == 7)
            {
                ham_SetObjHFlip(sprites[0], 0);
                ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[8 * 16 * 32 /2]);
            }
        //end sprite updating info
        //NPC Update code
        for (int x = 0; x < maplist[watashi.map].numsprite; x++)
        {
            if((watashi.x <= maplist[watashi.map].sprite[x * 4] + 7)  && (watashi.x >= maplist[watashi.map].sprite[x * 4]  - 8))//29
            {
                ham_SetObjX(x+1, (tempspritex[x+1] += 2));
            }
        }
        //END NPC Update code
        hel_MapScrollBy(&MapInfo[3], -2, 0);
    }

    if(delay % 2 && dir == RIGHT)
    {
        //sprite updatin info
        if (delay == 15)
            {
                ham_SetObjHFlip(sprites[0], 1);
                ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[7 * 16 * 32 /2]);
            }
        if (delay == 7)
            {
                ham_SetObjHFlip(sprites[0], 1);
                ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[8 * 16 * 32 /2]);
            }
        //end sprite updating info
        //NPC Update code
        for (int x = 0; x < maplist[watashi.map].numsprite; x++)
        {
            if((watashi.x <= maplist[watashi.map].sprite[x * 4] + 8)  && (watashi.x >= maplist[watashi.map].sprite[x * 4] - 7))//29
            {
                ham_SetObjX(x+1, (tempspritex[x+1] -= 2));
            }
        }
        //END NPC Update code
        hel_MapScrollBy(&MapInfo[3], 2, 0);
    }

    if(delay % 2 && dir == DOWN)
    {
        //sprite updatin info
        if (delay == 15)
            {
                ham_SetObjHFlip(sprites[0], 0);
                ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[6 * 16 * 32 /2]);
            }
        if (delay == 7)
            {
                ham_SetObjHFlip(sprites[0], 0);
                ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[0 * 16 * 32 /2]);
            }
        //end sprite updating info
        //NPC Update code
        for (int x = 0; x < maplist[watashi.map].numsprite; x++)
        {
            if((watashi.y <= maplist[watashi.map].sprite[x * 4 + 1] + 6)  && (watashi.y >= maplist[watashi.map].sprite[x * 4 + 1]  - 4)) //9
            {
                ham_SetObjY(x+1, (tempspritey[x+1]  -= 2));
            }
        }
        //END NPC Update code
        hel_MapScrollBy(&MapInfo[3], 0, 2);
    }
    //end scrolling info
    if(delay)
    {
        delay--;

        //sprite gfx update
        if(!hel_Pad.Held.Up && delay == 0 && dir == UP)
        {
            ham_SetObjHFlip(sprites[0], 0);
            ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[4 * 16 * 32 / 2]);
        }
        if(!hel_Pad.Held.Left && delay == 0 && dir == LEFT)
        {
            ham_SetObjHFlip(sprites[0], 0);
            ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[2 * 16 * 32 / 2]);
        }
        if(!hel_Pad.Held.Right && delay == 0 && dir == RIGHT)
        {
            ham_SetObjHFlip(sprites[0], 1);
            ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[2 * 16 * 32 / 2]);
        }
        if(!hel_Pad.Held.Down && delay == 0 && dir == DOWN)
        {
            ham_SetObjHFlip(sprites[0], 0);
            ham_UpdateObjGfx(sprites[0], (void*)&celessprite_Bitmap[3 * 16 * 32 / 2]);
        }
        //end sprite update gfx
        
        //start RANDOM BATTLE code section
        //BOSS CHECK
        if(delay == 0 && watashi.map == 7 && watashi.x == 9 && watashi.y == 4)
        {
            watashi.monster = 10;
            return 4;
        }
        //END BOSS CHECK
        if(delay == 0 && stepstobattle == 0 && maplist[watashi.map].monster)
        {
            dir = 0;
            stepstobattle = 6 + D2d6;
            //less scorpions
            if(watashi.map == 3)
            {
                stepstobattle = stepstobattle + D2d6 + 9;
            }
            watashi.monster = maplist[watashi.map].monster;
            return 4;
        }
        if(delay == 0 && stepstobattle != 0 && maplist[watashi.map].monster)
        {
            stepstobattle--;
        }
        //end RANDOM BATTLE code section
        return 0;
    }
    //change map area
    if(watashi.x == 0 && dir && maplist[ curmap].west)
    {
        dir = 0;
        watashi.x = maplist[ curmap].westx;
        watashi.y = maplist[ curmap].westy;
        watashi.map = maplist[ watashi.map].west;
        return 2;
    }
    if(watashi.y == 0 && dir && maplist[ curmap].north)
    {
        dir = 0;
        watashi.x = maplist[ curmap].northx;
        watashi.y = maplist[ curmap].northy;
        watashi.map = maplist[ watashi.map].north;
        return 2;
    }
    if(watashi.y == (mapy - 1) && dir && maplist[ curmap].south)
    {
        dir = 0;
        watashi.x = maplist[ curmap].southx;
        watashi.y = maplist[ curmap].southy;
        watashi.map = maplist[ watashi.map].south;
        return 2;
    }
    if(watashi.x == (mapx - 1) && dir && maplist[ curmap].east)
    {
        dir = 0;
        watashi.x = maplist[ curmap].eastx;
        watashi.y = maplist[ curmap].easty;
        watashi.map = maplist[ curmap].east;
        return 2;
    }
    //end change map area
    dir = 0;
    return 0;  //thought you'd never make it here but it happens quite often :-)
}


/* END OF FILE */
